package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;
import com.fs.starfarer.api.impl.campaign.ids.HullMods;

public class SWP_SupplyConservationProgram extends BaseHullMod {

    public static final float CREW_MULT = 0.5f;
    public static final float CR_PEAK_PENALTY = 50f;
    public static final float CR_PENALTY = 100f;
    public static final float LOGISTICS_BONUS = 50f;

    @Override
    public void applyEffectsBeforeShipCreation(HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getMinCrewMod().modifyMult(id, CREW_MULT);
        stats.getSuppliesPerMonth().modifyMult(id, 1f - LOGISTICS_BONUS * 0.01f);
        stats.getPeakCRDuration().modifyMult(id, 1f - CR_PEAK_PENALTY * 0.01f);
        stats.getCRLossPerSecondPercent().modifyPercent(id, CR_PENALTY);
    }

    @Override
    public String getDescriptionParam(int index, HullSize hullSize) {
        if (index == 0) {
            return "halves";
        }
        if (index == 1) {
            return "halves";
        }
        if (index == 2) {
            return "halves";
        }
        if (index == 3) {
            return "twice";
        }
        return null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if ((ship.getHullSpec().getNoCRLossTime() >= 10000 || ship.getHullSpec().getCRLossPerSecond() <= 0)) {
            return "Ship is too efficient already";
        }
        if (ship.getVariant().hasHullMod(HullMods.CIVGRADE)) {
            return "Can not be installed on civilian ships";
        }
        if (ship.getVariant().hasHullMod(HullMods.AUTOMATED)) {
            return "Can not be installed on automated ships";
        }
        if (ship.getVariant().hasHullMod("maximized_ordinance")) {
            return "Incompatible with Extreme Modifications";
        }

        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains(HullMods.CIVGRADE) &&
                !ship.getVariant().getHullMods().contains(HullMods.AUTOMATED) &&
                (ship.getHullSpec().getNoCRLossTime() < 10000 ||
                 ship.getHullSpec().getCRLossPerSecond() > 0) &&
                !ship.getVariant().getHullMods().contains("maximized_ordinance");
    }
}
